<?php
function my_theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );

//add new code here

add_filter( 'wpseo_json_ld_output', '__return_false' );
/*****~~~!~~~ START: SITEMAP CODE ~~~!~~~*****/
/******************--- MediaNV Code for Generate Dynamic XML Sitemap --- 17-08-2021--- Tuesday ---**********************/ 

/* function to create sitemap.xml file in root directory of site  */        

add_action( "save_post", "generate_dynamic_sitemap" );   
function generate_dynamic_sitemap() 
{
    if ( str_replace( '-', '', get_option( 'gmt_offset' ) ) < 10 ) 
    { 
        $tempo = '-0' . str_replace( '-', '', get_option( 'gmt_offset' ) ); 
    } else 
    { 
        $tempo = get_option( 'gmt_offset' ); 
    }
    if( strlen( $tempo ) == 3 ) { $tempo = $tempo . ':00'; }
    $postsForSitemap = get_posts( array(
        'numberposts' => -1,
        'orderby'     => 'modified',
        'post_type'   => array( 'post', 'page', 'services', 'team_member', 'doctor', 'project', 'portfolio', 'service', 'team-member', 'staff', 'doctors', 'events_media', 'career', 'calendar', 'programs', 'newsandevents', 'testimonial' ),
        'order'       => 'DESC',
        'exclude' => array( 295, 307,295,113, 444, 1378, 895, 1375 ),
    ) );

    $sitemap = '<?xml version="1.0" encoding="UTF-8"?>' ;
    $sitemap .= "\n" . '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n"; 
     
     $sitemap .= "\t" . '<url>' . "\n" .
            "\t\t" . '<loc>' . esc_url( home_url( '/' ) ) . '</loc>' .
            //"\n\t\t" . '<lastmod>' . date( "Y-m-d\TH:i:s", current_time( 'timestamp', 0 ) ) . $tempo . '</lastmod>' .
            "\n\t\t" . '<changefreq>weekly</changefreq>' .
            "\n\t\t" . '<priority>1.00</priority>' .
            "\n\t" . '</url>' . "\n";

            
            
    foreach( $postsForSitemap as $post ) 
    {
        if ( get_post_type($post) == 'services' ) 
        {
            $priority = '0.80';
        }
        if ( get_post_type($post) == 'page' ) 
        {
            $priority = '0.80';
        }
        elseif (get_post_type($post) == 'post' || 
                get_post_type($post) == 'team-member' || 
                get_post_type($post) == 'team' || 
                get_post_type($post) == 'doctor' || 
                get_post_type($post) == 'case_study' || 
                get_post_type($post) == 'portfolio' || 
                get_post_type($post) == 'lawyer' || 
                get_post_type($post) == 'staff' || 
                get_post_type($post) == 'doctors' || 
                get_post_type($post) == 'events_media' || 
                get_post_type($post) == 'career' || 
                get_post_type($post) == 'calendar' || 
                get_post_type($post) == 'programs' || 
                get_post_type($post) == 'newsandevents' || 
                get_post_type($post) == 'testimonial' )
            {
               $priority = '0.60';
            }
        setup_postdata( $post );   
        $postdate = explode( " ", $post->post_modified );   
        $sitemap .= "\t" . '<url>' . "\n" .
            "\t\t" . '<loc>' . get_permalink( $post->ID ) . '</loc>' .
            //"\n\t\t" . '<lastmod>' . $postdate[0] . '</lastmod>' .
            "\n\t\t" . '<changefreq>weekly</changefreq>' .
            "\n\t\t" . '<priority>'.$priority.'</priority>' .
            "\n\t" . '</url>' . "\n";
    }

    $sitemap .= '</urlset>'; 
    $fp = fopen( ABSPATH . "sitemap.xml", 'w' );
    fwrite( $fp, $sitemap );
    fclose( $fp );
}
/*****~~~!~~~ END: SITEMAP CODE ~~~!~~~*****/