<?php
/*

Plugin Name: MediaNV SEO
Plugin URI:  https://medianv.com
Description: MediaNV SEO Plugin to stored and display custom schema tags in <HTML> head tags as per posts and pages.
Version:     7.0.1
Author:      WP Dev - MediaNV
Author URI:  https://medianv.com
Text Domain: MediaNV
Domain Path: /languages
License:     GPL2
*/

if ( !class_exists( 'mediaNV_SEO_Plugin' ) ) {
    class mediaNV_SEO_Plugin
    {
        public static function init() {
			load_plugin_textdomain( 'mediaNV', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
			add_action('add_meta_boxes', ['mediaNV_SEO_Plugin', 'add_schema_field']);
			add_action('save_post', ['mediaNV_SEO_Plugin', 'save_schema_field']);
			add_action('wp_head', ['mediaNV_SEO_Plugin', 'add_to_wphead'],999);
			add_action( 'admin_enqueue_scripts', ['mediaNV_SEO_Plugin', 'mediaNV_enqueue_admin_script']);
			add_filter('plugins_api', ['mediaNV_SEO_Plugin','mediaNV_seo_plugin_info'], 20, 3);
			//add_filter('site_transient_update_plugins', ['mediaNV_SEO_Plugin','mediaNV_seo_push_update'] );
			// add_action( 'upgrader_process_complete', ['mediaNV_SEO_Plugin','mediaNV_seo_after_update'], 10, 2 );
        }

        public static function add_schema_field()
		{
			$screens = ['post', 'page', 'service', 'services' , 'doctor' , 'staff' ,'team' ,'career' ,'locations' , 'landing'];
			foreach ($screens as $screen) {
				add_meta_box(
					'schema_box_id',          // Unique ID
					'Schema', // Box title
					[self::class, 'schema_field'],   // Content callback, must be of type callable
					$screen                  // Post type that we require to add
				);
			}
		}

		public static function save_schema_field($post_id)
		{
			if (array_key_exists('schema_field', $_POST)) {
				update_post_meta(
					$post_id,
					'schema_field',
					$_POST['schema_field']
				);
			}
		}

		public static function schema_field($post)
		{
			$value = get_post_meta($post->ID, 'schema_field', true);
			?>
			<label class="label-schema" for="schema_field">For Schema Field</label>
			<textarea name="schema_field" id="schema_field" class="schemabox"><?php echo @$value;?></textarea>
			<?php
		}

		public static function add_to_wphead()
		{
			global $post;
			$value = get_post_meta($post->ID, 'schema_field', true);
			if(isset($value)){
				echo $value;
			}
		}

		public static function mediaNV_enqueue_admin_script()
		{
			wp_enqueue_style('mediaNV_css', plugins_url('admin/css/admin_css.css',__FILE__ ));
		}

		/*
		* $res empty at this step
		* $action 'plugin_information'
		* $args stdClass Object ( [slug] => woocommerce [is_ssl] => [fields] => Array ( [banners] => 1 [reviews] => 1 [downloaded] => [active_installs] => 1 ) [per_page] => 24 [locale] => en_US )
		*/

		public static function mediaNV_seo_plugin_info( $res, $action, $args ){
			// do nothing if this is not about getting plugin information
			if( 'plugin_information' !== $action ) {
				return false;
			}

			$plugin_slug = 'medianv-seo'; // we are going to use it in many places in this function
			// do nothing if it is not our plugin
			if( $plugin_slug !== $args->slug ) {
				return false;				
			}
			return false;
		}	
    }
    mediaNV_SEO_Plugin::init();    
}