<?php



/**

 * The admin-specific functionality of the plugin.

 *

 * @link       https://aheadoftheweb.com/

 * @since      1.0.0

 *

 * @package    Aow_gf_failure_notification

 * @subpackage Aow_gf_failure_notification/admin

 */



/**

 * The admin-specific functionality of the plugin.

 *

 * Defines the plugin name, version, and two examples hooks for how to

 * enqueue the admin-specific stylesheet and JavaScript.

 *

 * @package    Aow_gf_failure_notification

 * @subpackage Aow_gf_failure_notification/admin

 * @author     Graeme <ggibson@123dentist.com>

 */

class Aow_gf_failure_notification_Admin {



	/**

	 * The ID of this plugin.

	 *

	 * @since    1.0.0

	 * @access   private

	 * @var      string    $plugin_name    The ID of this plugin.

	 */

	private $plugin_name;



	/**

	 * The version of this plugin.

	 *

	 * @since    1.0.0

	 * @access   private

	 * @var      string    $version    The current version of this plugin.

	 */

	private $version;



	/**

	 * Initialize the class and set its properties.

	 *

	 * @since    1.0.0

	 * @param      string    $plugin_name       The name of this plugin.

	 * @param      string    $version    The version of this plugin.

	 */

	public function __construct( $plugin_name, $version ) {



		$this->plugin_name = $plugin_name;

		$this->version = $version;

		

		add_action( 'gform_after_email', array( $this, 'aow_gform_failure_notification' ), 10, 12 );
		
		add_action( 'gform_after_submission', array( $this, 'aow_gform_airtable_notification' ), 10, 2 );

		

	}

	

	

	



	public function aow_gform_failure_notification( $is_success, $to, $subject, $message, $headers, $attachments, $message_format, $from, $from_name, $bcc, $reply_to, $entry ){

	if( !$is_success && is_plugin_active('gravityformssendgrid/sendgrid.php') ){

		$website_url = get_site_url();



		$gf_entry = $entry[ 'id' ];



		$ch = curl_init();



		$curl_data = array();



		$curl_data[ 'data' ] = array(

		'assignee' => '1200001696984250',

		'completed' => false,

		'due_on' => date('Y-m-d'),

		'name' => "$website_url - gravity forms failure",

		'notes' => "$website_url has had a failure in gravity forms on entry #$gf_entry",

		'projects' => array( '1200599410207465' ),

		);



		$curl_data_json = json_encode( $curl_data );



		curl_setopt($ch, CURLOPT_URL, 'https://app.asana.com/api/1.0/tasks');

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		curl_setopt($ch, CURLOPT_POST, 1);

		curl_setopt($ch, CURLOPT_POSTFIELDS, "$curl_data_json");



		$headers = array();

		$headers[] = 'Content-Type: application/json';

		$headers[] = 'Accept: application/json';

		$headers[] = 'Authorization: Bearer 1/10273265425006:63b68d7a2ddea11ad3ec81ade66e39d3';

		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);



		$result = curl_exec($ch);

		if (curl_errno($ch)) {

			echo 'Error:' . curl_error($ch); die();

		}

		curl_close($ch);
		
	}

	

}
	
	
	public function aow_gform_airtable_notification( $entry, $form ){

		$website_url = get_site_url();

		$ch = curl_init();

		$curl_data = array();
		
		$field_object = array();
		
		$field_human = "";
		
		// Let's go through all the fields
		foreach( $form[ 'fields' ] as $f ){
			
			// If the inputs is null, it means that we can get the field entry directly from the field id
			if( is_null( $f->inputs ) ){
				
				if( isset( $entry[ $f->id ] ) ){
					$field_object[ $f->label ] = $entry[ $f->id ];
				}	
				
			// If the inputs is not null it means the field has sub fields like 1.2, 1.3, 1.4
			}else{
				
				foreach( $f->inputs as $fi ){
				
					if( isset( $entry[ $fi[ 'id' ] ] ) ){
						$field_object[ $fi[ 'label' ] ] = $entry[ $fi[ 'id' ] ];
					}	
					
				}
				
			}
			
		}
		
		
		foreach( $field_object as $f => $o ){
		
			$field_human .= "$f: $o \n";
			
		}
		
		$notifications = array();
		
		$toEmail = FALSE;
		$bccEmail = FALSE;
		
		if( isset( $form[ 'notifications' ] ) && is_array( $form[ 'notifications' ] ) ){
			
			foreach( $form[ 'notifications' ] as $n ){
				if( $n[ 'isActive' ] == 'true' ){
					array_push( $notifications, $n );
					$toEmail  .= " " . $n[ 'toEmail' ];
					$bccEmail .= " " . $n[ 'bcc' ];
				}
			}
		}
		
		if( $toEmail ){
			$field_human .= "to: $toEmail \n";
		}
		
		if( $bccEmail ){
			$field_human .= "bcc: $bccEmail \n";
		}
		
		$confirmation = array();
		
		if( isset( $form[ 'confirmation' ] ) && is_array( $form[ 'confirmation' ] ) ){
			
			array_push( $confirmation, $form[ 'confirmation' ] );
			
			global $post;
		
			$thankyoutype = $form[ 'confirmation' ][ 'type' ];
			$thankyoumsg  = get_page_link( $form[ 'confirmation' ][ 'pageId' ] ) . "?" . $form[ 'confirmation' ][ 'queryString' ];
			$field_human .= "thank-you type: $thankyoutype \n";
			$field_human .= "thank-you msg: $thankyoumsg \n";
			
		}else{
			$field_human .= "thank-you type: Not Set \n";
			$field_human .= "thank-you msg: Not Set \n";
		}

		$curl_data[ 'data' ] = array(

			'form_id' => $form[ 'id' ],
			
			'entry_id' => $entry[ 'id' ],

			'title' => $form[ 'title' ],
			
			'source_url' => $entry[ 'source_url' ],

			'submitted' => date('Y-m-d'),

			'form_fields' => '"' . json_encode( $form[ 'fields' ] ) . '"',
			
			'form_notifications' => '"' . json_encode( $notifications ) . '"',
			
			'form_confirmation' => '"' . json_encode( $confirmation ) . '"',
			
			'form_entry' => '"' . json_encode( $entry ) . '"',
			
			'field_object' => '"' . json_encode( $field_object ) . '"',
			
			'field_human' => $field_human,

		);



		$curl_data_json = json_encode( $curl_data );



		curl_setopt($ch, CURLOPT_URL, 'https://hooks.zapier.com/hooks/catch/294529/3m698im/');

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		curl_setopt($ch, CURLOPT_POST, 1);

		curl_setopt($ch, CURLOPT_POSTFIELDS, "$curl_data_json");



		$headers = array();

		$headers[] = 'Content-Type: application/json';

		$headers[] = 'Accept: application/json';

		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);



		$result = curl_exec($ch);

		if (curl_errno($ch)) {

			echo 'Error:' . curl_error($ch); die();

		}

		curl_close($ch);

}



	/**

	 * Register the stylesheets for the admin area.

	 *

	 * @since    1.0.0

	 */

	public function enqueue_styles() {



		/**

		 * This function is provided for demonstration purposes only.

		 *

		 * An instance of this class should be passed to the run() function

		 * defined in Aow_gf_failure_notification_Loader as all of the hooks are defined

		 * in that particular class.

		 *

		 * The Aow_gf_failure_notification_Loader will then create the relationship

		 * between the defined hooks and the functions defined in this

		 * class.

		 */



		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/aow_gf_failure_notification-admin.css', array(), $this->version, 'all' );



	}



	/**

	 * Register the JavaScript for the admin area.

	 *

	 * @since    1.0.0

	 */

	public function enqueue_scripts() {



		/**

		 * This function is provided for demonstration purposes only.

		 *

		 * An instance of this class should be passed to the run() function

		 * defined in Aow_gf_failure_notification_Loader as all of the hooks are defined

		 * in that particular class.

		 *

		 * The Aow_gf_failure_notification_Loader will then create the relationship

		 * between the defined hooks and the functions defined in this

		 * class.

		 */



		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/aow_gf_failure_notification-admin.js', array( 'jquery' ), $this->version, false );



	}



}

